clear

%% Import data from text file.
% Script for importing data from the following text file:
%
%    C:\Users\Claudio
%    PETUCCO\Documents\MATLAB\Chalara\weib_estim_START_FINAL.csv
%
% To extend the code to different selected data or a different text file,
% generate a function instead of a script.

% Auto-generated by MATLAB on 2015/10/16 17:50:46

%% Initialize variables.
filename = 'C:\Users\Claudio PETUCCO\Documents\MATLAB\Chalara\weib_estim_START_FINAL.csv';
delimiter = ',';
startRow = 2;

%% Format string for each line of text:
%   column1: double (%f)
%	column2: double (%f)
%   column3: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%f%f%f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, 'Delimiter', delimiter, 'EmptyValue' ,NaN,'HeaderLines' ,startRow-1, 'ReturnOnError', false);

%% Close the text file.
fclose(fileID);

%% Post processing for unimportable data.
% No unimportable data rules were applied during the import, so no post
% processing code is included. To generate code which works for
% unimportable data, select unimportable cells in a file and regenerate the
% script.

%% Create output variable
data = [dataArray{1:end-1}];
%% Clear temporary variables
clearvars filename delimiter startRow formatSpec fileID dataArray ans;




%% PARAMETER ESTIMATION


% We'll fit the data with a Weibull distribution, then plot a histogram of the data, scaled to integrate to 1, and superimpose the fitted PDF.

newser=unique(data(:,3));
OUTPUT=zeros(numel(newser),3);

for i=1:numel(newser)
    id=find(data(:,3)==newser(i));
    ser=data(min(id):max(id),:);

        x=rude(ser(:,2),ser(:,1))';
        pdf_weibd=@(x,b,c) c/b*((x-7.5)./b).^(c-1).*exp(-((x-7.5)./b).^c);
        start=[20,2];
        [paramEsts_ml,paramCIs_ml] = mle(x, 'pdf',pdf_weibd, 'start',start);
        
        OUTPUT(i,:)=[paramEsts_ml,newser(i)];
        
% %         % Graphical output
%         f=figure;
%         binWidth = 5;
%         binCtrs = 0:binWidth:max(x);
%         counts = hist(x,binCtrs);
%         n = length(x);
%         prob = counts / (n * binWidth);
%         bar(binCtrs,prob,'hist');
%         h_gca = gca;
%         h = h_gca.Children;
%         h.FaceColor = [.9 .9 .9];
%         xlabel('Diameter');
%         ylabel('Probability Density');
%         ylim([0 0.06]);
%         xgrid = linspace(0,100);
%         xgrid_tr = linspace(7.5,100);
%         title(sprintf('NEWSER%d',newser(i)));
%         
%         pdfEst_ml=weib3(paramEsts_ml,xgrid_tr);
%         line(xgrid_tr,pdfEst_ml)
%         
%         saveas(f,sprintf('Figure/NEWSER/FIG%d.jpg',newser(i))); % will create FIG1, FIG2,...
%         

end

OUTPUT=[OUTPUT;0,0,105];



T = array2table(OUTPUT, 'VariableNames',{'Scale' 'Shape' 'newser'});



 writetable(T,'EstPar.csv')


 close all
 
x=0.5;
a=OUTPUT(:,1);
b=OUTPUT(:,2);

prob=zeros(67,10);

for i=1:10
    x=(7.5+(i-1)*10)*ones(67,1);
    prob(:,i)=1-exp(-((x-7.5)./a).^b);
end

S= [ prob(:,2:10), ones(67,1)] - prob;

S=[S,OUTPUT(:,3)];
S(67,1:10)=zeros(1,10);
T = array2table(S, 'VariableNames',{'d15' 'd25' 'd35' 'd45' 'd55' 'd65' 'd75' 'd85' 'd95' 'd150' 'newser'});

writetable(T,'Disagr.csv')

